<?php
/**
 * SISTEMA IPTV PREMIUM - SERIES HOME COMPACT PRO
 */
ini_set('memory_limit', '512M');
error_reporting(0);

include "session.php";
include "config.php";
include "header.php";

function getApiData($url) {
    if (session_status() === PHP_SESSION_NONE) { session_start(); }
    $cacheKey = md5($url);
    if (isset($_SESSION['api_cache'][$cacheKey]) && (time() - ($_SESSION['api_cache_time'][$cacheKey] < 300))) {
        return $_SESSION['api_cache'][$cacheKey];
    }
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_USERAGENT      => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) ProStream',
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_ENCODING       => "", 
        CURLOPT_TIMEOUT        => 12
    ]);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200 || !$response) return [];
    $decodedData = json_decode($response, true);
    
    if (is_array($decodedData)) {
        $_SESSION['api_cache'][$cacheKey] = $decodedData;
        $_SESSION['api_cache_time'][$cacheKey] = time();
        return $decodedData;
    }
    return [];
}

$get_dns = $get_dns ?? '';
$username = $username ?? '';
$password = $password ?? '';

// Conteúdos Iniciais
$recent_series = getApiData("$get_dns/player_api.php?username=$username&password=$password&action=get_series&limit=15");
$categories_api = getApiData("$get_dns/player_api.php?username=$username&password=$password&action=get_series_categories");
$initial_sections = array_slice($categories_api, 0, 5);
$later_sections = array_slice($categories_api, 5);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
    <title>WEB PLAYER</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;800&display=swap" rel="stylesheet" />
    <style>
        :root { 
            --primary: #ff003c; 
            --bg: #0a0a0c; 
            --glass: rgba(255, 255, 255, 0.05);
            --glass-border: rgba(255, 255, 255, 0.1); 
        }
        
        body { margin: 0; background: var(--bg); color: #fff; font-family: 'Montserrat', sans-serif; overflow-x: hidden; }

        /* HEADER E BOTÕES */
        .section-header { 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
            padding: 0 4%; 
            margin-top: 25px; /* Reduzido para ficar mais compacto */
        }
        
        .section-title { 
            font-size: 1.1rem; 
            font-weight: 800; 
            text-transform: uppercase;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .section-title::before {
            content: '';
            width: 4px;
            height: 18px;
            background: var(--primary);
            border-radius: 10px;
        }

        .btn-ver-tudo {
            background: var(--glass);
            border: 1px solid var(--glass-border);
            color: #eee;
            text-decoration: none;
            font-size: 0.7rem;
            font-weight: 700;
            padding: 5px 15px;
            border-radius: 20px;
            transition: 0.3s;
            text-transform: uppercase;
        }

        .btn-ver-tudo:hover {
            background: var(--primary);
            border-color: var(--primary);
            color: white;
        }

        /* GRID CARROSSEL COMPACTO */
        .grid-container { 
            display: flex; 
            gap: 12px; 
            overflow-x: auto; 
            padding: 15px 4%; 
            scrollbar-width: none; 
            -webkit-overflow-scrolling: touch;
        }
        .grid-container::-webkit-scrollbar { display: none; }
        
        .grid-item { 
            flex: 0 0 140px; 
            transition: transform 0.3s ease; 
            cursor: pointer;
        }
        
        .grid-item:hover { transform: translateY(-5px); }
        
        .grid-item img { 
            width: 100%; 
            height: 200px; /* Altura compacta */
            object-fit: cover; 
            border-radius: 10px; 
            border: 1px solid var(--glass-border);
            box-shadow: 0 8px 15px rgba(0,0,0,0.3);
        }
        
        .grid-item p { 
            font-size: 0.75rem; 
            margin-top: 8px; 
            font-weight: 600; 
            color: #bbb; 
            text-align: center;
            white-space: nowrap; 
            overflow: hidden; 
            text-overflow: ellipsis; 
        }

        /* RESPONSIVIDADE */
        @media (max-width: 768px) {
            .section-header { padding: 0 5%; margin-top: 20px; }
            .section-title { font-size: 0.95rem; }
            .grid-item { flex: 0 0 110px; }
            .grid-item img { height: 160px; }
        }
    </style>
</head>
<body>

<div class="section-header">
    <h2 class="section-title">Lançamentos</h2>
    <a href="series.php?id=recently_added" class="btn-ver-tudo">Ver Tudo</a>
</div>
<div class="grid-container">
    <?php foreach ($recent_series as $s): ?>
        <div class="grid-item" onclick="location.href='seriesvideo?id=<?= $s['series_id'] ?>'">
            <img src="<?= $s['cover'] ?>" onerror="this.src='img/sTREAMING (3) (1).png'" loading="lazy" />
            <p><?= htmlspecialchars($s['name']) ?></p>
        </div>
    <?php endforeach; ?>
</div>

<div id="php-sections">
    <?php foreach ($initial_sections as $sec): $cid = $sec["category_id"]; ?>
        <div class="section-header">
            <h2 class="section-title"><?= htmlspecialchars($sec["category_name"]) ?></h2>
            <a href="series.php?id=<?= $cid ?>" class="btn-ver-tudo">Ver Tudo</a>
        </div>
        <div class="grid-container">
            <?php
            $items = getApiData("$get_dns/player_api.php?username=$username&password=$password&action=get_series&category_id=$cid&limit=12");
            foreach ($items as $item):
            ?>
                <div class="grid-item" onclick="location.href='seriesvideo?id=<?= $item['series_id'] ?>'">
                    <img src="<?= $item['cover'] ?>" onerror="this.src='img/sTREAMING (3) (1).png'" loading="lazy" />
                    <p><?= htmlspecialchars($item["name"]) ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endforeach; ?>
</div>

<div id="lazy-sections"></div>

<script>
    let laterSections = <?= json_encode($later_sections); ?>;
    let currentIdx = 0;
    let isFetching = false;

    async function loadMore() {
        if (isFetching || currentIdx >= laterSections.length) return;
        isFetching = true;
        
        const section = laterSections[currentIdx];
        const container = document.getElementById('lazy-sections');
        
        const html = `
            <div class="section-header">
                <h2 class="section-title">${section.category_name}</h2>
                <a href="series.php?id=${section.category_id}" class="btn-ver-tudo">Ver Tudo</a>
            </div>
            <div class="grid-container" id="grid_${section.category_id}">
                <div style="color:rgba(255,255,255,0.3); font-size:0.8rem;">Carregando...</div>
            </div>`;
        
        container.insertAdjacentHTML('beforeend', html);

        try {
            const res = await fetch(`<?= $get_dns ?>/player_api.php?username=<?= $username ?>&password=<?= $password ?>&action=get_series&category_id=${section.category_id}&limit=12`);
            const data = await res.json();
            const grid = document.getElementById(`grid_${section.category_id}`);
            grid.innerHTML = data.map(m => `
                <div class="grid-item" onclick="location.href='seriesvideo?id=${m.series_id}'">
                    <img src="${m.cover}" onerror="this.src='img/sTREAMING (3) (1).png'" loading="lazy">
                    <p>${m.name}</p>
                </div>
            `).join('');
        } catch (e) { console.error(e); }
        
        currentIdx++;
        isFetching = false;
    }

    window.addEventListener('scroll', () => {
        if (window.innerHeight + window.scrollY >= document.body.offsetHeight - 1000) loadMore();
    }, { passive: true });
</script>
</body>
</html>